/*:
 * @target MZ
 *
 * @help
 * プラグインパラメータ指定したアニメーションを戦闘中キャラクターの下層に表示します。
 * 下層に表示するアニメーションIDをカンマ区切りで指定してください。
 *
 * @param LOWER_ANIMATIONS
 * @type string[]
 * @text 下層に表示するアニメーション
 * @desc 下層に表示するアニメーション
 * @default []
 *
 */

(() => {
    "use strict";
    const pluginName = document.currentScript.src.split("/").pop().replace(/\.js$/, "");
    const parameters = PluginManager.parameters(pluginName);

    //-----------------------------------------------------------------------------
    // Spriteset_Battle
    //-----------------------------------------------------------------------------
    const _SpritesetBattle_createBattleField = Spriteset_Battle.prototype.createBattleField;
    Spriteset_Battle.prototype.createBattleField = function() {
        this._lowerEffectsContainer = new Sprite();
        this._baseSprite.addChild(this._lowerEffectsContainer);
        _SpritesetBattle_createBattleField.call(this);
    };

    Spriteset_Battle.prototype.createAnimationSprite = function(
        targets, animation, mirror, delay
    ) {
        const lowerAnimations = JSON.parse(parameters["LOWER_ANIMATIONS"]).map(id => Number(id));
        if (lowerAnimations.includes(animation.id)) {
            const mv = this.isMVAnimation(animation);
            const sprite = new (mv ? Sprite_AnimationMV : Sprite_Animation)();
            const targetSprites = this.makeTargetSprites(targets);
            const baseDelay = this.animationBaseDelay();
            const previous = delay > baseDelay ? this.lastAnimationSprite() : null;
            if (this.animationShouldMirror(targets[0])) {
                mirror = !mirror;
            }
            sprite.targetObjects = targets;
            sprite.setup(targetSprites, animation, mirror, delay, previous);
            this._lowerEffectsContainer.addChild(sprite);
            this._animationSprites.push(sprite);
        } else {
            Spriteset_Base.prototype.createAnimationSprite.call(this, targets, animation, mirror, delay);
        }
    };

    Spriteset_Battle.prototype.removeAnimation = function(sprite) {
        this._lowerEffectsContainer.removeChild(sprite);
        Spriteset_Base.prototype.removeAnimation.call(this, sprite);
    };
})();

